function SequenceClass(name, mistakes, pattern){
	var name = name;
	var mistakes = mistakes;
	var pattern = pattern;
	var pair = null;
	var rules = "";
	var insertion = [0, ""];
	var color = colors.randomColor();
	var fontColor = rgbLuminance(color.replace("#", ""));


	this.setPair = function(p){
		if(p !== null || typeof p !== "object"){
			pair = p;
			color = pair.getColor();
			fontColor = pair.getFontColor();
		}
	}

	this.setColor = function(col){
		color = col;
		fontColor = rgbLuminance(color.replace("#", ""));
	}

	this.getColor = function(){
		return color;
	}
	
	this.getFontColor = function(){
		return fontColor;
	}
	
	this.setRule = function(r){
		rules = r;
	}
	
	this.getRule = function(){
		return rules;
	}
	
	this.setName = function(newName){
		name = newName;
	}
	
	this.getName = function(){
		return name;
	}
	
	this.setMistakes = function(mis){
		mistakes = mis;
	}
	
	this.getMistakes = function(){
		return mistakes;
	}
	
	this.setPattern = function(pat){
		pattern = pat;
	}
	
	this.getPattern = function(){
		return pattern;
	}
	
	this.getId = function(r){
		return name.replace("'", "-");
	}

	this.getPair = function(){
		if(pair === null && typeof pair === "object"){
			return null;
		}
		return pair;
	}
	
	this.getPairName = function(){
		if(pair === null && typeof pair === "object"){
			return null;
		}
		return pair.getName();
	}
	
	this.getPairPattern = function(){
		if(pair === null && typeof pair === "object"){
			return null;
		}
		return pair.getPattern();
	}
	
	this.getPairId = function(){
		if(pair === null && typeof pair === "object"){
			return null;
		}
		return pair.getName().replace("'", "-");
	} 
	
	this.getTagClass = function(){
		return name.replace("'", "");
	} 
	
	this.setInsertion = function(number, letter){
		if(isNaN(number)){
			number = 0;
		}
		insertion[0] = number;
		insertion[1] = letter;
	}
	
	this.getInsertion = function(){
		return insertion;
	}
	
	this.repr = function(){
		var mis = mistakes;
		var patt = pattern;
		if(pair !== null || typeof pair !== "object"){
			mis += ":" + pair.getMistakes();
			patt += ":" +pair.getPattern();
		}
		if(insertion[0] !== 0){
			mis += ":" + insertion[0];
			patt += ":" + insertion[1];
		}
		var result = name + " " + mis + " " + patt + " " + rules;
		return result;
	}
	
	function rgbLuminance(col){
		var r = parseInt(col.substr(0,2),16);
		var g = parseInt(col.substr(2,2),16);
		var b = parseInt(col.substr(4,2),16);
		var yiq = ((r*299)+(g*587)+(b*114))/1000;
		var c = (yiq >= 110) ? 'black' : 'white';
		return c;
	}
}